<?php

namespace Concept7\Deployer\Recipe\Laravel\Multitenancy;

use Concept7\Deployer\Recipe\Laravel\Laravel;
use Concept7\Deployer\Traits\Deployer;
use Concept7\Deployer\Traits\MultitenancyArtisan;
use Concept7\Deployer\Traits\ScheduleMonitor;
use Concept7\Deployer\Traits\UploadAssets;
use Concept7\Deployer\Traits\UploadComposerAuth;
use Concept7\Deployer\Traits\WorkersRestart;

class LaravelStatamic extends Laravel
{
    use Deployer;
    use MultitenancyArtisan;
    use ScheduleMonitor;
    use UploadAssets;
    use UploadComposerAuth;
    use WorkersRestart;

    /** @var array<string> */
    protected array $deploySteps = [
        'c7-deployer:info',
        'deploy:prepare',
        'upload:composer-auth',
        'deploy:vendors',
        'upload:assets',
        'artisan:storage:link',
        'artisan:optimize:clear',
        'artisan:optimize',
        'multitenancy:artisan:tenant:route:clear',
        'multitenancy:artisan:tenant:route:cache',
        'multitenancy:artisan:migrate',
        'deploy:publish',
        'php:restart',
        'opcache:clear',
        'workers:restart',
        'artisan:schedule-monitor:sync',
    ];

    /** @var array<string> */
    protected array $additionalDeployerRecipes = [
        'recipe/laravel.php',
        'recipe/statamic.php',
    ];

    public function loadExtraDeployerSteps(): void
    {
        $this->info();
        $this->uploadComposerAuth();
        $this->uploadAssets();
        $this->registerArtisanTasks();
        $this->workersRestart();
        $this->scheduleMonitorSync();
    }
}
