<?php

namespace Concept7\Deployer\Recipe\Laravel\Multitenancy;

use Concept7\Deployer\Recipe\Laravel\Laravel as LaravelLaravel;
use Concept7\Deployer\Traits\MultitenancyArtisan;
use Concept7\Deployer\Traits\UploadAssets;
use Concept7\Deployer\Traits\UploadComposerAuth;
use Concept7\Deployer\Traits\WorkersRestart;

class Laravel extends LaravelLaravel
{
    use MultitenancyArtisan;
    use UploadAssets;
    use UploadComposerAuth;
    use WorkersRestart;

    /** @var array<string> */
    protected array $deploySteps = [
        'deploy:prepare',
        'upload:composer-auth',
        'deploy:vendors',
        'upload:assets',
        'artisan:storage:link',
        'artisan:migrate',
        'deploy:publish',
        'php:restart',
        'opcache:clear',
        'artisan:config:cache',
        'artisan:event:cache',
        'artisan:route:cache',
        'artisan:view:cache',
        'workers:restart',
    ];

    /** @var array<string> */
    protected array $additionalDeployerRecipes = [
        'recipe/laravel.php',
    ];

    public function loadExtraDeployerSteps(): void
    {
        $this->uploadComposerAuth();
        $this->uploadAssets();
        $this->registerArtisanTasks();
        $this->workersRestart();
    }
}
