<?php

namespace Concept7\Deployer\Traits;

use Deployer\Exception\GracefulShutdownException;

use function Deployer\after;
use function Deployer\run;
use function Deployer\task;
use function Deployer\test;

trait CheckGitStatus
{
    public function checkGitStatus(): void
    {
        task('check:git-status', static function () {

            $statamicGitEnabledOutput = run('set -a; source {{current_path}}/.env; set +a; echo $STATAMIC_GIT_ENABLED');
            $hasDotGitDirectory = test('[ -d {{current_path}}/.git ]');

            $statamicGitEnabled = false;
            if (strlen($statamicGitEnabledOutput) > 0) {
                $statamicGitEnabled = $statamicGitEnabledOutput === 'true';
            }

            if ($statamicGitEnabled && $hasDotGitDirectory) {
                $lock = run('cd {{current_path}}; if [[ $(git cherry -v) ]]; then echo +locked; else echo "-locked"; fi');
                if ($lock === '+locked') {
                    run('cd {{current_path}}; git cherry -v');
                    throw new GracefulShutdownException("There are still some commits which haven't been pushed!");
                }

                $lock = run("cd {{current_path}}; if [[ $(git status --porcelain -uno . -- ':!storage' -- ':!public') ]]; then echo +locked; else echo '-locked'; fi");
                if ($lock === '+locked') {
                    run('cd {{current_path}}; git status');
                    throw new GracefulShutdownException("There are still some files which haven't been staged!");
                }
            }
        });
        after('deploy:setup', 'check:git-status');
    }
}
