<?php

namespace Concept7\Deployer\Recipe\Wordpress;

use Concept7\Deployer\Recipe\Base;
use Concept7\Deployer\Traits\UploadAssets;
use Concept7\Deployer\Traits\WpCache;
use Concept7\Deployer\Traits\WpRedis;

use function Deployer\set;
use function Deployer\which;

class Wordpress extends Base
{
    use UploadAssets;
    use WpCache;
    use WpRedis;

    public function __construct(
        private string $theme = 'default'
    ) {
        parent::__construct();

        $this->setWebPath('./web');

        $this->setWpBin();
    }

    /** @var array<string> */
    protected array $deploySteps = [
        'deploy:prepare',
        'deploy:vendors',
        'upload:assets',
        'deploy:publish',
        'php:restart',
        'cache:clear',
        'opcache:clear',
        'wp:redis-enable',
    ];

    /** @var array<string> */
    protected array $defaultSharedFiles = [
        '.env',
    ];

    /** @var array<string> */
    protected array $defaultSharedDirectories = [
        'web/app/uploads',
    ];

    /** @var array<string> */
    protected array $defaultWritableDirectories = [
        'web/app/uploads',
        'web/app/cache',
    ];

    /** @var array<string> */
    protected array $additionalDeployerRecipes = [
        //
    ];

    public function loadExtraDeployerSteps(): void
    {
        $this->uploadAssets([
            sprintf('web/app/themes/%s/assets', $this->theme),
        ]);
        $this->clearWpCache();
        $this->enableWpRedis();
    }

    public function setWpBin(): void
    {
        set('bin/wp', static function () {
            return '{{bin/php}} '.which('wp');
        });
    }
}
