<?php

namespace Concept7\Deployer\Recipe\StaticSite;

use Concept7\Deployer\Recipe\Base;
use Concept7\Deployer\Traits\Deployer;
use Concept7\Deployer\Traits\UploadPublic;

class StaticSite extends Base
{
    use Deployer;
    use UploadPublic;

    protected array $deploySteps = [
        'c7-deployer:info',
        'deploy:prepare',
        'upload:public',
        'deploy:publish',
        'php:restart',
        'opcache:clear',
    ];

    public function __construct(?string $distPath = null)
    {
        parent::__construct();

        $this->setWebPath('./public');
        if (! is_null($distPath)) {
            $this->setDistPath($distPath);
        }
    }

    public function loadExtraDeployerSteps(): void
    {
        $this->info();
        $this->uploadPublic();
    }
}
