<?php

namespace Concept7\Deployer\Traits;

use Concept7\Deployer\Enum\HostingType;

use function Deployer\currentHost;
use function Deployer\invoke;
use function Deployer\run;
use function Deployer\task;

trait PhpRestart
{
    private function phpRestart(): void
    {
        task('php:restart', static function () {
            $hostingType = HostingType::tryFrom(currentHost()->get('labels')['hostingType']);

            if ($hostingType === HostingType::Forge) {
                invoke('php-fpm:reload');
            }

            if ($hostingType === HostingType::Combell) {
                run('reloadPHP.sh');
            }
        });
    }
}
