<?php

namespace Concept7\Deployer\Traits;

use function Deployer\task;
use function Deployer\testLocally;
use function Deployer\upload;

trait UploadPublic
{
    private function uploadPublic(): void
    {
        task('upload:public', static function () {
            $config = [
                'flags' => '-az',
                'progress_bar' => false,
                'display_stats' => false,
            ];

            if (testLocally(sprintf('[ -d %s ]', 'public'))) {
                upload(
                    'public/',
                    '{{release_path}}/public',
                    $config
                );
            }
        });
    }
}
