<?php

namespace Concept7\Deployer\Recipe\Laravel;

use Concept7\Deployer\Traits\CheckGitStatus;
use Concept7\Deployer\Traits\Crontab;
use Concept7\Deployer\Traits\Deployer;
use Concept7\Deployer\Traits\Filament;
use Concept7\Deployer\Traits\LaravelOneTimeOperations;
use Concept7\Deployer\Traits\ManageForgeSite;
use Concept7\Deployer\Traits\ScheduleMonitor;
use Concept7\Deployer\Traits\SetCodeStrategy;
use Concept7\Deployer\Traits\Statamic\StatamicSearchUpdateAll;
use Concept7\Deployer\Traits\StatamicStaticWarm;
use Concept7\Deployer\Traits\Swagger;
use Concept7\Deployer\Traits\UploadAssets;
use Concept7\Deployer\Traits\UploadComposerAuth;
use Concept7\Deployer\Traits\WorkersRestart;

class LaravelStatamic extends Laravel
{
    use CheckGitStatus;
    use Crontab;
    use Deployer;
    use Filament;
    use LaravelOneTimeOperations;
    use ManageForgeSite;
    use ScheduleMonitor;
    use SetCodeStrategy;
    use StatamicSearchUpdateAll;
    use StatamicStaticWarm;
    use Swagger;
    use UploadAssets;
    use UploadComposerAuth;
    use WorkersRestart;

    /** @var array<string> */
    protected array $deploySteps = [
        'c7-deployer:info',
        'deploy:prepare',
        'upload:composer-auth',
        'deploy:vendors',
        'upload:assets',
        'artisan:storage:link',
        'artisan:migrate',
        'artisan:operations:process',
        'artisan:optimize:clear',
        'artisan:optimize',
        'artisan:filament:optimize',
        'artisan:view:cache',
        'artisan:event:cache',
        'statamic:stache:refresh',
        'statamic:static:clear',
        'statamic:glide:clear',
        'statamic:search:update:all',
        'deploy:publish',
        'php:restart',
        'opcache:clear',
        'workers:restart',
        'statamic:static:warm:queue',
        'crontabs:update',
        'artisan:schedule-monitor:sync',
        'artisan:l5-swagger:generate',
    ];

    /** @var array<string> */
    protected array $additionalDeployerRecipes = [
        'recipe/laravel.php',
        'recipe/statamic.php',
    ];

    /** @var array<string> */
    protected array $defaultSharedDirectories = [
        'storage/app',
        'storage/logs',
        'storage/redirect',
        'storage/forms',
        'storage/statamic/revisions',
    ];

    public function loadExtraDeployerSteps(): void
    {
        $this->info();
        $this->createSite();
        $this->deleteSite();
        $this->uploadComposerAuth();
        $this->uploadAssets();
        $this->checkGitStatus();
        $this->setCodeStrategy();
        $this->addLaravelSchedulerToCrontab();
        $this->workersRestart();
        $this->scheduleMonitorSync();
        $this->loadStatamicStaticWarmTask();
        $this->generateSwaggerDocs();
        $this->loadStatamicSearchUpdateTask();
        $this->operationsProcess();
        $this->filamentOptimize();
    }
}
