<?php

namespace Concept7\Deployer\Traits;

use Closure;
use Concept7\Deployer\Enum\HostingType;
use Deployer\Host\Host;
use Deployer\Task\Context;

use function Deployer\artisan;
use function Deployer\currentHost;
use function Deployer\desc;
use function Deployer\invoke;
use function Deployer\run;
use function Deployer\runLocally;
use function Deployer\task;
use function Deployer\warning;

trait WorkersRestart
{
    use FilterTasks;

    private function workersRestart(): void
    {
        task('workers:restart', function () {
            $hostingType = HostingType::tryFrom(currentHost()->get('labels')['hostingType']);

            if ($hostingType === HostingType::Forge || $hostingType === HostingType::Linfosys) {
                if ($this->isPackageInstalled('laravel/horizon')) {
                    invoke('artisan:horizon:terminate');
                }

                if ($this->isPackageInstalled('beyondcode/laravel-websockets')) {
                    task('artisan:websockets:restart', artisan('websockets:restart'));
                    invoke('artisan:websockets:restart');
                }

                if ($this->isPackageInstalled('laravel/reverb')) {
                    desc('Restarts Laravel Reverb');
                    task('artisan:reverb:restart', artisan('reverb:restart'));
                    invoke('artisan:reverb:restart');
                }
            }

            $host = Context::get()->getHost();

            if ($hostingType === HostingType::LinQhost) {
                $this->restartWorkers($host, static function ($name) use ($host) {
                    run(sprintf('curl -sLO %s/control/restart/localhost/%s ', 'https://'.$host->get('hostname').'/lh_supervisor', $name));
                });
            }

            if ($hostingType === HostingType::Combell) {
                $this->restartWorkers($host, static function ($name) use ($host) {
                    runLocally(sprintf('ssh -t %s %s platform worker restart -n %s', $host->connectionOptionsString(), $host->connectionString(), $name));
                });
            }
        });
    }

    private function restartWorkers(Host $host, Closure $callback): void
    {
        $names = $host->get('worker_names');
        if (empty($names)) {
            warning('Worker name(s) empty');

            return;
        }

        foreach (explode(',', $names) as $name) {
            $name = trim($name);
            $callback($name);
        }
    }
}
