<?php

namespace Concept7\Deployer\Traits;

use function Deployer\task;
use function Deployer\testLocally;
use function Deployer\upload;

trait UploadComposerAuth
{
    private function uploadComposerAuth(): void
    {
        task('upload:composer-auth', static function () {
            if (testLocally('[ -f auth.json ]')) {
                $options = [
                    'flags' => '-az',
                    'progress_bar' => false,
                    'display_stats' => false,
                ];

                upload('auth.json', '{{release_path}}', $options);
            }
        });
    }
}
