<?php

namespace Concept7\Deployer\Traits;

trait PhpVersion
{
    protected float $phpVersion = 8.0;

    public function phpVersion(float $version): self
    {
        $this->phpVersion = $version;

        return $this;
    }

    public function setPhpVersion(float $version): self
    {
        return $this->phpVersion($version);
    }

    public function getPhpVersion(): string
    {
        return number_format($this->phpVersion, 1);
    }
}
