### Setting up this repository in your projects
Add this Composer repository to your project's composer.json file.

```
{
  "repositories": [{
    "type": "composer",
    "url": "https://packagist.concept7.nl"
  }]
}
```


```
composer require concept7/deployer
```

Add to your deploy.php
### Laravel
```php
require __DIR__.'/vendor/autoload.php';

use Concept7\Deployer\Enum\Recipe;
use Concept7\Deployer\Loader;

$loader = new Loader();

$loader
    ->setProject(
        name: 'Project X',
        repository: 'git@github.com:project-x/project-x.git'
    )
    ->setRecipe(Recipe::Laravel)
    ->setPhpVersion(8.1)
    ->setStaging(
        host: 'projectx.staging.environment.xyz',
        deploy_path: '~/projectx.staging.environment.xyz',
    )
    ->setAcceptance(
        host: 'projectx.acceptance.environment.xyz',
        deploy_path: '~/projectx.acceptance.environment.xyz',
    )
    ->setProduction(
        host: 'project.com',
        hostname: 'server-host-name',
        port: 22622,
        remote_user: 'projectxcom',
        deploy_path: '/webroot',
    )
    ->setEnvironment(
        environment: 'debug-production'
        host: 'debug.projectx.com',
        hostname: 'server-host-name',
        port: 22622,
        remote_user: 'debug_projectxcom',
        deploy_path: '/webroot',
    )
    ->execute();
```



### Shared directories

### Overwrite
To overwrite default shared directories, use the following method. And the preferred directories. eg. complete storage folder
```php
->setSharedDirectories([
    'storage'
])
```

### Add
To add extra to shared directories, use the following method.
```php
->addSharedDirectories([
    'extra_shared_dir_name',
])
```

## Wordpress

```php
require __DIR__.'/vendor/autoload.php';

use Concept7\Deployer\Loader;
use Concept7\Deployer\Recipe\Wordpress\Wordpress;

$loader = new Loader();

$loader
    ->setProject(
        name: 'Project Y',
        repository: 'git@github.com:project-y/project-y.git'
    )
   ->recipe(new Wordpress(
        theme: 'projecty'
    ))
    ->addSharedFiles([
        'web/app/themes/projecty/extrafolder/config.php',
    ])
    ->addWritableDirs([
        'web/app/themes/projecty/extrafolder',
    ])
    ->setStaging(
        host: 'projecty.staging.environment.xyz',
        deploy_path: '~/projecty.staging.environment.xyz',
    )
    ->setAcceptance(
        host: 'projecty.acceptance.environment.xyz',
        deploy_path: '~/projecty.acceptance.environment.xyz',
    )
    ->setProduction(
        host: 'projecty.com',
        hostname: 'server-host-name',
        remote_user: 'projecty',
        deploy_path: '~/webroot',
    )
    ->execute();
```
