<?php

namespace Concept7\Deployer\Traits;

use function Deployer\run;
use function Deployer\task;
use function Deployer\test;

trait PhpFpmReload
{
    private function setupPhpFpmReload()
    {
        task('php-fpm-reload', ['php-fpm:reload'])
            ->select(implode(',', ['env=staging', 'env=testing', 'env=acceptance']));

        task('reload-php-sh', static function () {
            $reloadPhpExists = test('[ -f reloadPHP.sh ]');
            if ($reloadPhpExists) {
                run('reloadPHP.sh');
            }
        })
            ->select('env=production');

        task('reload-php', ['php-fpm-reload', 'reload-php-sh']);
    }
}
