<?php

namespace Concept7\Deployer;

use Concept7\Deployer\Enum\Recipe;
use Concept7\Deployer\Recipe\Base;
use Concept7\Deployer\Recipe\Laravel\Laravel;
use Concept7\Deployer\Recipe\Laravel\LaravelStatamic;
use Concept7\Deployer\Recipe\Laravel\Multitenancy\Laravel as MultitenancyLaravel;
use Concept7\Deployer\Recipe\Laravel\Multitenancy\LaravelStatamic as MultitenancyLaravelStatamic;
use Concept7\Deployer\Recipe\Laravel\Multitenancy\Statamic as MultitenancyStatamic;
use Concept7\Deployer\Recipe\Laravel\Statamic;
use Deployer\Exception\Exception;

class Loader
{
    private Recipe $recipe;

    private string $name;

    private string $repository;

    private float $phpVersion = 8.0;

    private array $environments = [];

    public function setProject(string $name, string $repository)
    {
        $this->name = $name;
        $this->repository = $repository;

        return $this;
    }

    public function setRecipe(Recipe $recipe)
    {
        $this->recipe = $recipe;

        return $this;
    }

    public function setPhpVersion(float $version)
    {
        $this->phpVersion = $version;

        return $this;
    }

    public function setEnvironment(
        string $environment,
        string $host,
        string $deploy_path,
        string $hostname,
        string $remote_user,
        int $port = 22,
        string $branch = 'main'
    ) {
        if (isset($this->environments[$environment])) {
            throw new Exception('Environment: ['.$environment.'] already defined');
        }

        $this->environments[$environment] = [
            'host' => $host,
            'hostname' => $hostname,
            'remote_user' => $remote_user,
            'port' => $port,
            'branch' => $branch,
            'deploy_path' => $deploy_path,
        ];

        return $this;
    }

    public function setStaging(
        string $host,
        string $deploy_path,
        string $hostname = '37.97.131.190',
        string $remote_user = 'forge',
        int $port = 22,
        string $branch = 'develop'
    ) {
        return $this->setEnvironment(
            environment: 'staging',
            host: $host,
            hostname: $hostname,
            remote_user: $remote_user,
            port: $port,
            branch: $branch,
            deploy_path: $deploy_path,
        );
    }

    public function setAcceptance(
        string $host,
        string $deploy_path,
        string $hostname = '149.210.205.153',
        string $remote_user = 'forge',
        int $port = 22,
        string $branch = 'main'
    ) {
        return $this->setEnvironment(
            environment: 'acceptance',
            host: $host,
            hostname: $hostname,
            remote_user: $remote_user,
            port: $port,
            branch: $branch,
            deploy_path: $deploy_path,
        );
    }

    public function setProduction(
        string $host,
        string $deploy_path,
        string $hostname,
        string $remote_user,
        int $port = 22,
        string $branch = 'main'
    ) {
        return $this->setEnvironment(
            environment: 'production',
            host: $host,
            hostname: $hostname,
            remote_user: $remote_user,
            port: $port,
            branch: $branch,
            deploy_path: $deploy_path,
        );
    }

    public function execute()
    {
        $recipe = match ($this->recipe) {
            Recipe::Laravel => Laravel::class,
            Recipe::LaravelStatamic => LaravelStatamic::class,
            Recipe::Statamic => Statamic::class,
            Recipe::MultitenancyLaravel => MultitenancyLaravel::class,
            Recipe::MultitenancyLaravelStatamic => MultitenancyLaravelStatamic::class,
            Recipe::MultitenancyStatamic => MultitenancyStatamic::class,
            default => throw new \Exception('Recipe ['.$this->recipe.'] not found')
        };

        /** @var Base */
        $class = new $recipe();

        return $class
            ->setRepository($this->repository)
            ->setApplication($this->name)
            ->setPhpVersion($this->phpVersion)
            ->setEnvironments($this->environments)
            ->run();
    }
}
