<?php

namespace Concept7\Deployer\Traits;

use function Deployer\task;
use function Deployer\upload;

trait UploadAssets
{
    private function uploadAssets($buildDir = true, $jsDir = false, $cssDir = false)
    {
        task('upload:assets', static function () use ($buildDir, $jsDir, $cssDir) {
            if ($buildDir) {
                upload('public/build/', '{{release_path}}/public/build', ['flags' => '-az', 'progress_bar' => false, 'display_stats' => false]);
            }
            
            if ($cssDir) {
                upload('public/css/', '{{release_path}}/public/css', ['flags' => '-az', 'progress_bar' => false, 'display_stats' => false]);
            }
            
            if ($jsDir) {
                upload('public/js/', '{{release_path}}/public/js', ['flags' => '-az', 'progress_bar' => false, 'display_stats' => false]);
            }
        });
    }
}
