<?php

namespace Concept7\Deployer\Recipe\Wordpress;

use Concept7\Deployer\Recipe\Base;

class Wordpress extends Base
{
    protected $deploySteps = [
        'deploy:prepare',
        'deploy:vendors',
        'rsync',
        'deploy:publish',
        'reload-php',
        'cachetool:clear:opcache',
    ];

    protected $additionalDeployerRecipes = [
        //
    ];

    public function loadExtraDeployerSteps(): void
    {
        //
    }

    public function setSharedFiles(array $files = []): void
    {
        set('shared_files', $files);
        // set('shared_files', [
        //     '.env',
        //     'web/app/themes/kijck/tiara/config.php',
        //     'web/app/themes/kijck/tiara/aanbod/config.php',
        //     'web/app/themes/kijck/tiara/aanbod/search.json',
        //     'web/app/themes/kijck/tiara/nieuwbouw/project/config.php',
        //     'web/app/themes/kijck/tiara/nieuwbouw/project/search.json',
        //     'web/app/themes/kijck/tiara/nieuwbouw/type/config.php',
        //     'web/app/themes/kijck/tiara/nieuwbouw/type/search.json',
        // ]);
    }

    public function setSharedDirs(array $directories = ['web/app/uploads']): void
    {
        set('shared_dirs', $directories);
    }

    public function setWritableDirs(array $directories = []): void
    {
        set('writable_dirs', [
            'web/app/uploads',
            'web/app/cache',
            'web/app/themes/kijck/tiara',
        ]);
    }

    public function setRsyncDirectories(string $src, string $dest): void
    {
        set('rsync_src', $src);
        set('rsync_dest', $dest);
    }
}
