<?php

namespace Concept7\Deployer\Recipe\Laravel;

use Concept7\Deployer\Recipe\Base;
use Concept7\Deployer\Traits\CheckGitStatus;
use Concept7\Deployer\Traits\HorizonTerminate;
use Concept7\Deployer\Traits\RestartSupervisordDaemon;
use Concept7\Deployer\Traits\SetCodeStrategy;
use Concept7\Deployer\Traits\UploadAssets;
use Concept7\Deployer\Traits\UploadVendors;

class Statamic extends Base
{
    use CheckGitStatus;
    use HorizonTerminate;
    use RestartSupervisordDaemon;
    use SetCodeStrategy;
    use UploadAssets;
    use UploadVendors;

    protected $deploySteps = [
        'deploy:prepare',
        'upload:vendors',
        'upload:assets',
        'artisan:storage:link',
        'deploy:publish',
        'reload-php',
        'cachetool:clear:opcache',
        'artisan:optimize:clear',
        'artisan:optimize',
        'artisan:view:cache',
        'artisan:event:cache',
        'statamic:stache:refresh',
        'forge:artisan:horizon:terminate',
        'supervisord-daemon-restart',
    ];

    protected $additionalDeployerRecipes = [
        'recipe/statamic.php',
    ];

    public function loadExtraDeployerSteps(): void
    {
        $this->uploadVendors();
        $this->uploadAssets();
        $this->forgeHorizonTerminate();
        $this->checkGitStatus();
        $this->setCodeStrategy();
        $this->setupSupervisord();
    }
}
