<?php

namespace Concept7\Deployer\Recipe\Laravel;

use Concept7\Deployer\Recipe\Base;
use Concept7\Deployer\Traits\HorizonTerminate;
use Concept7\Deployer\Traits\RestartSupervisordDaemon;
use Concept7\Deployer\Traits\UploadAssets;
use Concept7\Deployer\Traits\UploadVendors;

class Laravel extends Base
{
    use HorizonTerminate;
    use RestartSupervisordDaemon;
    use UploadAssets;
    use UploadVendors;

    protected $deploySteps = [
        'deploy:prepare',
        'upload:vendors',
        'upload:assets',
        'artisan:storage:link',
        'artisan:migrate',
        'deploy:publish',
        'reload-php',
        'cachetool:clear:opcache',
        'artisan:config:cache',
        'artisan:event:cache',
        'artisan:route:cache',
        'artisan:view:cache',
        'forge:artisan:horizon:terminate',
        'supervisord-daemon-restart',
    ];

    protected $additionalDeployerRecipes = [
        'recipe/laravel.php',
    ];

    public function loadExtraDeployerSteps(): void
    {
        $this->uploadVendors();
        $this->uploadAssets();
        $this->forgeHorizonTerminate();
        $this->setupSupervisord();
    }
}
