<?php

namespace Concept7\Deployer\Traits;

use function Deployer\task;
use function Deployer\upload;

trait UploadVendors
{
    private function uploadVendors(bool $publicVendor = true, bool $wpDir = false): void
    {
        task('upload:vendors', static function () use ($publicVendor, $wpDir) {
            upload('vendor/', '{{release_path}}/vendor', ['flags' => '-az', 'progress_bar' => false, 'display_stats' => false]);

            if ($publicVendor) {
                upload('public/vendor/', '{{release_path}}/public/vendor', ['flags' => '-az', 'progress_bar' => false, 'display_stats' => false]);
            }

            if ($wpDir) {
                upload('web/wp/', '{{release_path}}/web/wp', ['flags' => '-az', 'progress_bar' => false, 'display_stats' => false]);
                upload('web/app/mu-plugins/', '{{release_path}}/web/app/mu-plugins', ['flags' => '-az', 'progress_bar' => false, 'display_stats' => false]);
                upload('web/app/plugins/', '{{release_path}}/web/app/plugins', ['flags' => '-az', 'progress_bar' => false, 'display_stats' => false]);
            }
        });
    }
}
