<?php

namespace Concept7\Deployer\Recipe\Laravel\Multitenancy;

use Concept7\Deployer\Recipe\Laravel\Laravel;
use Concept7\Deployer\Traits\HorizonTerminate;
use Concept7\Deployer\Traits\MultitenancyArtisan;
use Concept7\Deployer\Traits\UploadAssets;
use Concept7\Deployer\Traits\UploadVendors;
use Concept7\Deployer\Traits\WorkersRestart;

use function Deployer\artisan;

class LaravelStatamic extends Laravel
{
    use HorizonTerminate;
    use MultitenancyArtisan;
    use UploadAssets;
    use UploadVendors;
    use WorkersRestart;

    /** @var array<string> */
    protected array $deploySteps = [
        'deploy:prepare',
        'upload:vendors',
        'upload:assets',
        'artisan:storage:link',
        // 'artisan:config:cache',
        // 'tenant:artisan:route:cache',
        // 'artisan:view:cache',
        // 'artisan:event:cache',
        'landlord:artisan:migrate',
        'tenant:artisan:migrate',
        // 'tenant:artisan:queue:restart',
        'deploy:publish',
        'workers:restart',
    ];

    /** @var array<string> */
    protected array $additionalDeployerRecipes = [
        'recipe/laravel.php',
        'recipe/statamic.php',
    ];

    public function loadExtraDeployerSteps(): void
    {
        $this->uploadVendors();
        $this->uploadAssets(buildDir: true, jsDir: true, cssDir: true);
        $this->forgeHorizonTerminate();
        $this->registerArtisanTasks();
        $this->forgeHorizonTerminate();
        $this->workersRestart();
    }
}
