<?php

namespace Concept7\Deployer\Recipe\Laravel;

use Concept7\Deployer\Recipe\Base;
use Concept7\Deployer\Traits\ScheduleMonitor;
use Concept7\Deployer\Traits\UploadAssets;
use Concept7\Deployer\Traits\UploadVendors;
use Concept7\Deployer\Traits\WorkersRestart;

class Laravel extends Base
{
    use ScheduleMonitor;
    use UploadAssets;
    use UploadVendors;
    use WorkersRestart;

    /** @var array<string> */
    protected array $deploySteps = [
        'deploy:prepare',
        'upload:vendors',
        'upload:assets',
        'artisan:storage:link',
        'artisan:migrate',
        'artisan:optimize:clear',
        'artisan:optimize',
        'artisan:view:cache',
        'artisan:event:cache',
        'deploy:publish',
        'php:restart',
        'opcache:clear',
        'workers:restart',
        'artisan:schedule-monitor:sync',
    ];

    /** @var array<string> */
    protected array $defaultSharedFiles = [
        '.env',
    ];

    /** @var array<string> */
    protected array $defaultSharedDirectories = [
        'storage',
    ];

    /** @var array<string> */
    protected array $defaultWritableDirectories = [
        'bootstrap/cache',
        'storage',
        'storage/app',
        'storage/app/public',
        'storage/framework',
        'storage/framework/cache',
        'storage/framework/cache/data',
        'storage/framework/sessions',
        'storage/framework/views',
        'storage/logs',
    ];

    /** @var array<string> */
    protected array $additionalDeployerRecipes = [
        'recipe/laravel.php',
    ];

    public function __construct()
    {
        parent::__construct();

        $this->setWebPath('./public');
    }

    public function loadExtraDeployerSteps(): void
    {
        $this->uploadVendors();
        $this->uploadAssets();
        $this->workersRestart();
        $this->scheduleMonitorSync();
    }
}
