<?php

namespace Concept7\Deployer\Traits;

use Deployer\Exception\Exception;

use function Deployer\invoke;
use function Deployer\runLocally;
use function Deployer\set;
use function Deployer\task;
use function Deployer\warning;

trait Opcache
{
    private string $webPath;

    public function setWebPath(string $path): void
    {
        $this->webPath = $path;
    }

    public function opcacheClear(): void
    {
        set('cachetool_args', '--web=FileGetContents --web-path='.$this->webPath.' --web-url=https://{{alias}}');

        task('opcache:clear', static function () {
            $status = runLocally('curl --head --silent https://{{alias}} | head -n 1 2> /dev/null');
            $urlNotFound = str_contains($status, (string) 404);

            if ($status && ! $urlNotFound) {
                try {
                    invoke('cachetool:clear:opcache');
                } catch (Exception $e) {
                    warning('⚠️  Command failed, but continuing... Message:'.$e->getMessage());
                }
            } else {
                warning("Url: https://{{alias}} doesn't seem to be correct. Maybe DNS or typo?");
            }
        });
    }
}
