<?php

namespace Concept7\Deployer\Traits;

use function Deployer\task;
use function Deployer\testLocally;
use function Deployer\upload;

trait UploadAssets
{
    /** @var array<string> */
    protected array $assets = [];

    /** @param  array<string>  $assets */
    public function setAssets(array $assets): self
    {
        $this->assets = $assets;

        return $this;
    }

    /** @return array<string> */
    public function getAssets(): array
    {
        return $this->assets;
    }

    public function addAsset(string $asset): self
    {
        $this->assets[] = $asset;

        return $this;
    }

    /** @param  array<string>  $additionalAssets */
    private function uploadAssets(array $additionalAssets = []): void
    {
        $assets = array_merge($additionalAssets, $this->assets);

        task('upload:assets', static function () use ($assets) {
            $config = [
                'flags' => '-az',
                'progress_bar' => false,
                'display_stats' => false,
            ];

            foreach ($assets as $asset) {
                if (testLocally(sprintf('[ -d %s ]', $asset))) {
                    upload(
                        $asset.'/',
                        '{{release_path}}/'.$asset,
                        $config
                    );
                }
            }
        });
    }
}
