<?php

namespace Concept7\Deployer\Recipe\Laravel;

use Concept7\Deployer\Traits\CheckGitStatus;
use Concept7\Deployer\Traits\Crontab;
use Concept7\Deployer\Traits\ScheduleMonitor;
use Concept7\Deployer\Traits\SetCodeStrategy;
use Concept7\Deployer\Traits\Statamic\StatamicSearchUpdateAll;
use Concept7\Deployer\Traits\StatamicStaticWarm;
use Concept7\Deployer\Traits\Swagger;
use Concept7\Deployer\Traits\UploadAssets;
use Concept7\Deployer\Traits\UploadVendors;
use Concept7\Deployer\Traits\WorkersRestart;

class LaravelStatamic extends Laravel
{
    use CheckGitStatus;
    use Crontab;
    use ScheduleMonitor;
    use SetCodeStrategy;
    use StatamicSearchUpdateAll;
    use StatamicStaticWarm;
    use Swagger;
    use UploadAssets;
    use UploadVendors;
    use WorkersRestart;

    /** @var array<string> */
    protected array $deploySteps = [
        'deploy:prepare',
        'upload:vendors',
        'upload:assets',
        'artisan:storage:link',
        'artisan:migrate',
        'artisan:optimize:clear',
        'artisan:optimize',
        'artisan:view:cache',
        'artisan:event:cache',
        'statamic:stache:refresh',
        'statamic:static:clear',
        'statamic:glide:clear',
        'statamic:search:update:all',
        'deploy:publish',
        'php:restart',
        'opcache:clear',
        'workers:restart',
        'statamic:static:warm:queue',
        'crontabs:update',
        'artisan:schedule-monitor:sync',
        'artisan:l5-swagger:generate',
    ];

    /** @var array<string> */
    protected array $additionalDeployerRecipes = [
        'recipe/laravel.php',
        'recipe/statamic.php',
    ];

    /** @var array<string> */
    protected array $defaultSharedDirectories = [
        'storage/app',
        'storage/logs',
        'storage/redirect',
        'storage/forms',
        'storage/statamic/revisions',
    ];

    public function loadExtraDeployerSteps(): void
    {
        $this->uploadVendors();
        $this->uploadAssets();
        $this->checkGitStatus();
        $this->setCodeStrategy();
        $this->addLaravelSchedulerToCrontab();
        $this->workersRestart();
        $this->scheduleMonitorSync();
        $this->loadStatamicStaticWarmTask();
        $this->addLaravelSchedulerToCrontab();
        $this->generateSwaggerDocs();
        $this->loadStatamicSearchUpdateTask();
    }
}
