<?php

namespace Concept7\Deployer\Traits;

use function Deployer\task;
use function Deployer\upload;

trait UploadAssets
{
    private function uploadAssets(bool $buildDir = true, bool $jsDir = false, bool $cssDir = false, ?string $wpAssetsDir = null): void
    {
        task('upload:assets', static function () use ($buildDir, $jsDir, $cssDir, $wpAssetsDir) {
            $config = [
                'flags' => '-az',
                'progress_bar' => false,
                'display_stats' => false,
            ];

            if ($buildDir) {
                upload('public/build/', '{{release_path}}/public/build', $config);
            }

            if ($cssDir) {
                upload('public/css/', '{{release_path}}/public/css', $config);
            }

            if ($jsDir) {
                upload('public/js/', '{{release_path}}/public/js', $config);
            }

            if ((bool) $wpAssetsDir) {
                upload(
                    'web/app/themes/'.$wpAssetsDir.'/assets/',
                    '{{release_path}}/web/app/themes/'.$wpAssetsDir.'/assets',
                    $config
                );
            }
        });
    }
}
