<?php

namespace Concept7\Deployer\Traits;

use function Deployer\artisan;
use function Deployer\desc;
use function Deployer\run;
use function Deployer\task;
use function Deployer\warning;

trait StatamicStaticWarm
{
    public function loadStatamicStaticWarmTask(): void
    {
        desc('Warms the static cache by visiting all URLs through queue');
        task('statamic:static:warm-queue', static function () {

            $staticCachingStrategy = run('set -a; source {{release_or_current_path}}/.env; set +a; echo $STATAMIC_STATIC_CACHING_STRATEGY');
            if ($staticCachingStrategy) {
                artisan('statamic:static:warm --queue');
            } else {
                warning('Static cache seems to be disabled');
            }
        });
    }
}
