<?php

namespace Concept7\Deployer\Traits;

use Concept7\Deployer\Enum\HostingType;

use function Deployer\run;
use function Deployer\task;

trait PhpRestart
{
    private function phpRestart(): void
    {
        task('forge:php:restart', ['php-fpm:reload'])
            ->select('hostingType='.HostingType::Forge->value);

        task('combell:php:restart', static function () {
            run('reloadPHP.sh');
        })
            ->select('hostingType='.HostingType::Combell->value);

        task('php:restart', ['forge:php:restart', 'combell:php:restart']);
    }
}
