<?php

namespace Concept7\Deployer\Traits;

use function Deployer\task;
use function Deployer\testLocally;
use function Deployer\upload;

trait UploadPublic
{
    private string $distPath = 'public/';

    private function setDistPath(string $distPath): void
    {
        $this->distPath = $distPath;
    }

    private function uploadPublic(): void
    {
        $distPath = $this->distPath;

        task('upload:public', static function () use ($distPath) {
            $config = [
                'flags' => '-az',
                'progress_bar' => false,
                'display_stats' => false,
            ];

            if (testLocally(sprintf('[ -d %s ]', 'public'))) {
                upload(
                    $distPath,
                    '{{release_path}}/public',
                    $config
                );
            }
        });
    }
}
