<?php

namespace Concept7\Deployer\Traits;

use function Deployer\task;
use function Deployer\testLocally;
use function Deployer\upload;

trait UploadVendors
{
    private function uploadVendors(): void
    {
        task('upload:vendors', static function () {
            $options = [
                'flags' => '-az',
                'progress_bar' => false,
                'display_stats' => false,
            ];

            upload('vendor/', '{{release_path}}/vendor', $options);

            if (testLocally('[ -d public/vendor ]')) {
                upload('public/vendor/', '{{release_path}}/public/vendor', $options);
            }

            if (testLocally('[ -d web/wp ]')) {
                upload('web/wp/', '{{release_path}}/web/wp', $options);
            }

            if (testLocally('[ -d web/app/mu-plugins ]')) {
                upload('web/app/mu-plugins/', '{{release_path}}/web/app/mu-plugins', $options);
            }

            if (testLocally('[ -d web/app/plugins ]')) {
                upload('web/app/plugins/', '{{release_path}}/web/app/plugins', $options);
            }
        });
    }
}
