<?php

namespace Concept7\DeployerExtended\Traits;

use function Deployer\run;
use function Deployer\task;
use function Deployer\test;

trait PhpFpmReload
{
    private function setupPhpFpmReload()
    {
        task('php-fpm-reload', ['php-fpm:reload'])
            ->select(implode(',', ['stage=staging', 'stage=testing', 'stage=acceptance']));

        task('reload-php-sh', function () {
            $reloadPhpExists = test('[ -f reloadPHP.sh ]');
            if ($reloadPhpExists) {
                run('reloadPHP.sh');
            }
        })
            ->select('stage=production');

        task('reload-php', ['php-fpm-reload', 'reload-php-sh']);
    }
}
