<?php

namespace Concept7\DeployerExtended\Traits;

use Deployer\Exception\GracefulShutdownException;

use function Deployer\after;
use function Deployer\run;
use function Deployer\task;

trait CheckGitStatus
{
    public function checkGitStatus()
    {
        task('check:git-status', function () {
            $locked = run('cd {{current_path}}; if [[ $(git cherry -v) ]]; then echo +locked; else echo "-locked"; fi');
            if ($locked === '+locked') {
                throw new GracefulShutdownException("There are still some Git commits which haven't been pushed!");
            }
        });
        after('deploy:setup', 'check:git-status');
    }
}
