<?php

namespace Concept7\DeployerExtended\Recipe\Laravel\Multitenancy;

use Concept7\DeployerExtended\Recipe\Base;
use Concept7\DeployerExtended\Traits\CheckGitStatus;
use Concept7\DeployerExtended\Traits\HorizonTerminate;
use Concept7\DeployerExtended\Traits\MultitenancyArtisan;
use Concept7\DeployerExtended\Traits\RestartSupervisordDaemon;
use Concept7\DeployerExtended\Traits\SetCodeStrategy;
use Concept7\DeployerExtended\Traits\UploadAssets;
use Concept7\DeployerExtended\Traits\UploadVendors;

class Statamic extends Base
{
    use CheckGitStatus;
    use HorizonTerminate;
    use MultitenancyArtisan;
    use RestartSupervisordDaemon;
    use SetCodeStrategy;
    use UploadAssets;
    use UploadVendors;

    protected $deploySteps = [
        'deploy:prepare',
        'upload:vendors',
        'rsync',
        'artisan:storage:link',
        'artisan:optimize:clear',
        'statamic:stache:warm',
        'deploy:publish',
        'php-fpm-reload',
        'forge:artisan:horizon:terminate',
        'supervisord-daemon-restart',
    ];

    protected $additionalDeployerRecipes = [
        'recipe/statamic.php',
    ];

    public function loadExtraDeployerSteps(): void
    {
        $this->uploadVendors();
        $this->uploadAssets();
        $this->forgeHorizonTerminate();
        $this->checkGitStatus();
        $this->setCodeStrategy();
        $this->registerArtisanTasks();
        $this->setupSupervisord();
    }
}
