<?php

namespace Concept7\DeployerExtended\Recipe\Laravel\Multitenancy;

use Concept7\DeployerExtended\Recipe\Base;
use Concept7\DeployerExtended\Traits\HorizonTerminate;
use Concept7\DeployerExtended\Traits\MultitenancyArtisan;
use Concept7\DeployerExtended\Traits\RestartSupervisordDaemon;
use Concept7\DeployerExtended\Traits\UploadAssets;
use Concept7\DeployerExtended\Traits\UploadVendors;

use function Deployer\artisan;

class LaravelStatamic extends Base
{
    use HorizonTerminate;
    use MultitenancyArtisan;
    use RestartSupervisordDaemon;
    use UploadAssets;
    use UploadVendors;

    protected $deploySteps = [
        'deploy:prepare',
        'upload:vendors',
        'upload:assets',
        'artisan:storage:link',
        // 'artisan:config:cache',
        'tenant:artisan:route:cache',
        // 'artisan:view:cache',
        // 'artisan:event:cache',
        'landlord:artisan:migrate',
        'tenant:artisan:migrate',
        'tenant:artisan:queue:restart',
        'deploy:publish',
    ];

    protected $additionalDeployerRecipes = [
        'recipe/laravel.php',
        'recipe/statamic.php',
    ];

    public function loadExtraDeployerSteps(): void
    {
        $this->uploadVendors();
        $this->uploadAssets(buildDir: true, jsDir: true, cssDir: true);
        $this->forgeHorizonTerminate();
        $this->registerArtisanTasks();
        $this->setupSupervisord();
    }
}
