<?php

namespace Concept7\DeployerExtended\Recipe\Laravel\Multitenancy;

use Concept7\DeployerExtended\Recipe\Base;
use Concept7\DeployerExtended\Traits\HorizonTerminate;
use Concept7\DeployerExtended\Traits\MultitenancyArtisan;
use Concept7\DeployerExtended\Traits\RestartSupervisordDaemon;
use Concept7\DeployerExtended\Traits\UploadAssets;
use Concept7\DeployerExtended\Traits\UploadVendors;

class Laravel extends Base
{
    use HorizonTerminate;
    use MultitenancyArtisan;
    use RestartSupervisordDaemon;
    use UploadAssets;
    use UploadVendors;

    protected $deploySteps = [
        'deploy:prepare',
        'upload:vendors',
        'upload:assets',
        'artisan:storage:link',
        'artisan:migrate',
        'deploy:publish',
        'php-fpm-reload',
        'cachetool:clear:opcache',
        'artisan:config:cache',
        'artisan:route:cache',
        'artisan:view:cache',
        'artisan:event:cache',
        'forge:artisan:horizon:terminate',
        'supervisord-daemon-restart',
    ];

    protected $additionalDeployerRecipes = [
        'recipe/laravel.php',
    ];

    public function loadExtraDeployerSteps(): void
    {
        $this->uploadVendors();
        $this->uploadAssets();
        $this->forgeHorizonTerminate();
        $this->registerArtisanTasks();
        $this->setupSupervisord();
    }
}
