<?php

namespace Concept7\DeployerExtended;

use Concept7\DeployerExtended\Enum\Recipe;
use Concept7\DeployerExtended\Recipe\Base;
use Concept7\DeployerExtended\Recipe\Laravel\Laravel;
use Concept7\DeployerExtended\Recipe\Laravel\LaravelStatamic;
use Concept7\DeployerExtended\Recipe\Laravel\Multitenancy\Laravel as MultitenancyLaravel;
use Concept7\DeployerExtended\Recipe\Laravel\Multitenancy\LaravelStatamic as MultitenancyLaravelStatamic;
use Concept7\DeployerExtended\Recipe\Laravel\Multitenancy\Statamic as MultitenancyStatamic;
use Concept7\DeployerExtended\Recipe\Laravel\Statamic;

class Loader
{
    private Recipe $recipe;

    private string $name;

    private string $repository;

    private float $phpVersion = 8.0;

    private array $stagingEnv = [];

    private array $acceptanceEnv = [];

    private array $productionEnv = [];

    private string $baseDir;

    public function __construct()
    {

    }

    public function setBaseDir(string $dir)
    {
        $this->baseDir = $dir;

        return $this;
    }

    public function setProject(string $name, string $repository)
    {
        $this->name = $name;
        $this->repository = $repository;

        return $this;
    }

    public function setRecipe(Recipe $recipe)
    {
        $this->recipe = $recipe;

        return $this;
    }

    public function setPhpVersion(float $version)
    {
        $this->phpVersion = $version;

        return $this;
    }

    public function setStaging(
        string $host,
        string $deploy_path,
        string $hostname = '37.97.131.190',
        string $remote_user = 'forge',
        int $port = 22,
        string $branch = 'develop'
    ) {
        $this->stagingEnv = [
            'host' => $host,
            'hostname' => $hostname,
            'remote_user' => $remote_user,
            'port' => $port,
            'branch' => $branch,
            'deploy_path' => $deploy_path,
        ];

        return $this;
    }

    public function setAcceptance(
        string $host,
        string $deploy_path,
        string $hostname = '149.210.205.153',
        string $remote_user = 'forge',
        int $port = 22,
        string $branch = 'main'
    ) {
        $this->acceptanceEnv = [
            'host' => $host,
            'hostname' => $hostname,
            'remote_user' => $remote_user,
            'port' => $port,
            'branch' => $branch,
            'deploy_path' => $deploy_path,
        ];

        return $this;
    }

    public function setProduction(
        string $host,
        string $deploy_path,
        string $hostname,
        string $remote_user,
        int $port = 22,
        string $branch = 'main'
    ) {
        $this->productionEnv = [
            'host' => $host,
            'hostname' => $hostname,
            'remote_user' => $remote_user,
            'port' => $port,
            'branch' => $branch,
            'deploy_path' => $deploy_path,
        ];

        return $this;
    }

    public function execute()
    {
        $recipe = match ($this->recipe) {
            Recipe::Laravel => Laravel::class,
            Recipe::LaravelStatamic => LaravelStatamic::class,
            Recipe::Statamic => Statamic::class,
            Recipe::MultitenancyLaravel => MultitenancyLaravel::class,
            Recipe::MultitenancyLaravelStatamic => MultitenancyLaravelStatamic::class,
            Recipe::MultitenancyStatamic => MultitenancyStatamic::class,
            default => throw new \Exception('meh')
        };

        /** @var Base */
        $class = new $recipe();

        $class = $class
            ->setBaseDir($this->baseDir)
            ->setRepository($this->repository)
            ->setApplication($this->name)
            ->setPhpVersion($this->phpVersion);

        if (count($this->stagingEnv)) {
            $class = $class->setStaging(
                host: $this->stagingEnv['host'],
                deploy_path: $this->stagingEnv['deploy_path'],
                hostname: $this->stagingEnv['hostname'],
                remote_user: $this->stagingEnv['remote_user'],
                port: $this->stagingEnv['port'],
                branch: $this->stagingEnv['branch']
            );
        }

        if (count($this->acceptanceEnv)) {
            $class = $class->setAcceptance(
                host: $this->acceptanceEnv['host'],
                deploy_path: $this->acceptanceEnv['deploy_path'],
                hostname: $this->acceptanceEnv['hostname'],
                remote_user: $this->acceptanceEnv['remote_user'],
                port: $this->acceptanceEnv['port'],
                branch: $this->acceptanceEnv['branch']
            );
        }
        if (count($this->productionEnv)) {
            $class = $class->setProduction(
                host: $this->productionEnv['host'],
                deploy_path: $this->productionEnv['deploy_path'],
                hostname: $this->productionEnv['hostname'],
                remote_user: $this->productionEnv['remote_user'],
                port: $this->productionEnv['port'],
                branch: $this->productionEnv['branch']
            );
        }

        return $class->run();
    }
}
