```php
require __DIR__.'/vendor/autoload.php';

use Concept7\DeployerExtended\Enum\Recipe;
use Concept7\DeployerExtended\Loader;

$loader = new Loader();

$loader
    ->setProject(
        name: 'POH Digitaal',
        repository: 'git@gitlab.concept7.nl:poh-digitaal/poh-digitaal.git'
    )
    ->setRecipe(Recipe::Laravel)
    ->setPhpVersion(8.1)
    ->setStaging(
        host: 'poh-digitaal.staging.concept7.dev',
        deploy_path: '~/poh-digitaal.staging.concept7.dev',
    )
    ->setAcceptance(
        host: 'poh-digitaal.acceptance.concept7.dev',
        deploy_path: '~/poh-digitaal.acceptance.concept7.dev',
    )
    ->setProduction(
        host: 'beheer.pohdigitaal.nl',
        hostname: 'd-concept7-6.host-ed.eu',
        port: 22622,
        remote_user: 'u_pohdigitaal',
        deploy_path: '/var/hpwsites/u_pohdigitaal/website/html/webroot',
    )
    ->execute();
```

### Wordpress

```php
require __DIR__.'/vendor/autoload.php';

use Concept7\DeployerExtended\Enum\Recipe;
use Concept7\DeployerExtended\Loader;

$loader = new Loader();

$loader
    ->setProject(
        name: 'Kijck Makelaars',
        repository: 'git@gitlab.concept7.nl:kijck/kijck-makelaars.git'
    )
    ->setRecipe(Recipe::Wordpress)
    ->setPhpVersion(8.0)
    // ->setSharedFiles([
    //     '.env',
    //     'web/app/themes/kijck/tiara/config.php',
    //     'web/app/themes/kijck/tiara/aanbod/config.php',
    //     'web/app/themes/kijck/tiara/aanbod/search.json',
    //     'web/app/themes/kijck/tiara/nieuwbouw/project/config.php',
    //     'web/app/themes/kijck/tiara/nieuwbouw/project/search.json',
    //     'web/app/themes/kijck/tiara/nieuwbouw/type/config.php',
    //     'web/app/themes/kijck/tiara/nieuwbouw/type/search.json',
    // ])
    // ->setSharedDirs([
    //     'web/app/uploads'
    // ])
    // ->setWritableDirs([
    //     'web/app/uploads',
    //     'web/app/cache',
    //     'web/app/themes/kijck/tiara',
    // ])
    // ->reloadPhp()
    // ->setRsyncDirectories(
    //     src:__DIR__.'/web/app/themes/kijck/assets'
    //     dest: '{{release_path}}/web/app/themes/kijck/assets'
    // )
    ->setStaging(
        host: 'kijck-makelaars.staging.concept7.dev',
        deploy_path: '~/kijck-makelaars.staging.concept7.dev',
    )
    ->setAcceptance(
        host: 'kijck-makelaars.acceptance.concept7.dev',
        deploy_path: '~/kijck-makelaars.acceptance.concept7.dev',
    )
    ->setProduction(
        host: 'kijck.nl',
        hostname: 'ssh059.hosting-cluster.nl',
        remote_user: 'kijcknl',
        deploy_path: '~/kijck.nl',
    )
    ->execute();
```



```
composer config repositories.253 composer https://gitlab.concept7.nl/api/v4/group/253/-/packages/composer/packages.json
composer require concept7/deployer

```