<?php

namespace Concept7\Deployer\Traits;

use Concept7\Deployer\Enum\HostingType;
use Deployer\Task\Context;

use function Deployer\artisan;
use function Deployer\run;
use function Deployer\runLocally;
use function Deployer\task;
use function Deployer\warning;
use function Deployer\writeln;

trait WorkersRestart
{
    use FilterTasks;

    private function workersRestart(): void
    {
        task('forge:horizon:restart', static function () {
            writeln('Restarting in Forge');
            artisan('horizon:terminate');
        })
            ->select('hostingType='.HostingType::Forge->value);

        task('forge:websockets:restart', static function () {
            writeln('Restarting in Forge');
            artisan('websockets:restart');
        })
            ->select('hostingType='.HostingType::Forge->value);

        task('linqhost:supervisord:restart', static function () {
            writeln('Restarting in LinQhost');
            $host = Context::get()->getHost();
            $names = $host->get('worker_names');
            if (empty($names)) {
                warning('Worker name(s) empty');

                return;
            }

            foreach (explode(',', $names) as $name) {
                $name = trim($name);
                $host = 'https://'.$host->get('hostname').'/lh_supervisor';
                run(sprintf('curl -sLO %s/control/restart/localhost/%s ', $host, $name));
            }
        })->select('hostingType='.HostingType::LinQhost->value);

        task('combell:worker:restart', static function () {
            writeln('Restarting in Combell');
            $host = Context::get()->getHost();
            $names = $host->get('worker_names');
            if (empty($names)) {
                warning('Worker name(s) empty');

                return;
            }

            foreach (explode(',', $names) as $name) {
                $name = trim($name);
                $options = $host->connectionOptionsString();
                runLocally(sprintf('ssh -t %s %s platform worker restart -n %s', $options, $host->connectionString(), $name));
            }
        })->select('hostingType='.HostingType::Combell->value);

        task('workers:restart', $this->filterBasedOnInstalledComposerPackages([
            'forge:horizon:restart',
            'forge:websockets:restart',
            'linqhost:supervisord:restart',
            'combell:worker:restart',
        ]));
    }
}
