<?php

namespace Concept7\Deployer\Traits;

use Composer\InstalledVersions;

trait FilterTasks
{
    /**
     * @param  array<string>  $deploySteps
     * @return array<string>
     */
    private function filterBasedOnInstalledComposerPackages(array $deploySteps = []): array
    {
        $filterOn = [
            'laravel/horizon' => 'forge:horizon:restart',
            'beyondcode/laravel-websockets' => 'forge:websockets:restart',
            'spatie/laravel-schedule-monitor' => 'artisan:schedule-monitor:sync',
        ];
        $installedComposerPackages = InstalledVersions::getInstalledPackages();

        foreach ($filterOn as $package => $taskName) {
            $deploySteps = array_filter(
                $deploySteps,
                static fn ($step) => $step !== $taskName || ($step === $taskName && in_array($package, $installedComposerPackages))
            );
        }

        return $deploySteps;
    }
}
