<?php

namespace Concept7\Deployer\Recipe\Laravel;

use Concept7\Deployer\Recipe\Base;
use Concept7\Deployer\Traits\CheckGitStatus;
use Concept7\Deployer\Traits\ScheduleMonitor;
use Concept7\Deployer\Traits\SetCodeStrategy;
use Concept7\Deployer\Traits\UploadAssets;
use Concept7\Deployer\Traits\UploadVendors;
use Concept7\Deployer\Traits\WorkersRestart;

class Statamic extends Base
{
    use CheckGitStatus;
    use ScheduleMonitor;
    use SetCodeStrategy;
    use UploadAssets;
    use UploadVendors;
    use WorkersRestart;

    /** @var array<string> */
    protected array $deploySteps = [
        'deploy:prepare',
        'upload:vendors',
        'upload:assets',
        'artisan:storage:link',
        'artisan:optimize:clear',
        'artisan:optimize',
        'artisan:view:cache',
        'artisan:event:cache',
        'statamic:stache:refresh',
        'statamic:static:clear',
        'statamic:glide:clear',
        'deploy:publish',
        'php:restart',
        'opcache:clear',
        'workers:restart',
        'artisan:schedule-monitor:sync',
    ];

    /** @var array<string> */
    protected array $additionalDeployerRecipes = [
        'recipe/statamic.php',
    ];

    public function loadExtraDeployerSteps(): void
    {
        $this->uploadVendors();
        $this->uploadAssets();
        $this->checkGitStatus();
        $this->setCodeStrategy();
        $this->workersRestart();
        $this->scheduleMonitorSync();
    }
}
