<?php

namespace Concept7\Deployer\Traits;

use Concept7\Deployer\Enum\HostingType;
use Deployer\Task\Context;

use function Deployer\artisan;
use function Deployer\run;
use function Deployer\runLocally;
use function Deployer\task;
use function Deployer\warning;
use function Deployer\writeln;

trait WebsocketsRestart
{
    private function websocketsRestart(): void
    {
        task('forge:websockets:restart', static function () {
            writeln('Restarting in Forge');
            artisan('websockets:restart');
        })
            ->select('hostingType='.HostingType::Forge->value);

        task('linqhost:websockets:restart', static function () {
            writeln('Restarting in LinQhost');
            $host = Context::get()->getHost();
            $name = $host->get('websocket_worker_name');
            if (! $name) {
                warning('Worker name missing');

                return;
            }

            $host = 'https://'.$host->get('hostname').'/lh_supervisor';
            run(sprintf('curl -sLO %s/control/restart/localhost/%s ', $host, $name));
        })->select('hostingType='.HostingType::LinQhost->value);

        task('combell:websockets:restart', static function () {
            writeln('Restarting in Combell');
            $host = Context::get()->getHost();
            $name = $host->get('websocket_worker_name');
            if (! $name) {
                warning('Worker name missing');

                return;
            }

            $options = $host->connectionOptionsString();
            runLocally(sprintf('ssh -t %s %s platform worker restart -n %s', $options, $host->connectionString(), $name));
        })->select('hostingType='.HostingType::Combell->value);

        task('websockets:restart', ['forge:websockets:restart', 'linqhost:websockets:restart', 'combell:websockets:restart']);
    }
}
