<?php

namespace Concept7\Deployer\Recipe\Wordpress;

use Concept7\Deployer\Recipe\Base;

use function Deployer\set;

class Wordpress extends Base
{
    /** @var array<string> */
    protected array $deploySteps = [
        'deploy:prepare',
        'deploy:vendors',
        'rsync',
        'deploy:publish',
        'reload-php',
        'cachetool:clear:opcache',
    ];

    /** @var array<string> */
    protected array $defaultSharedFiles = [
        '.env',
    ];

    /** @var array<string> */
    protected array $defaultSharedDirectories = [
        'web/app/uploads',
    ];

    /** @var array<string> */
    protected array $defaultWritableDirectories = [
        'web/app/uploads',
        'web/app/cache',
    ];

    /** @var array<string> */
    protected array $additionalDeployerRecipes = [
        //
    ];

    public function loadExtraDeployerSteps(): void
    {
        //
    }

    /** @param  array<string>  $files */
    public function setSharedFiles(array $files = []): void
    {
        $sharedFiles = [...$this->defaultSharedFiles, ...$files];

        if ($this->hasDotEnv) {
            $sharedFiles = array_filter($sharedFiles, static function ($file) {
                return $file !== '.env';
            });
        }

        set('shared_files', $sharedFiles);
    }

    /** @param  array<string>  $directories */
    public function setSharedDirs(array $directories = []): void
    {
        $sharedDirectories = [...$this->defaultSharedDirectories, ...$directories];

        set('shared_dirs', $sharedDirectories);
    }

    /** @param  array<string>  $directories */
    public function setWritableDirs(array $directories = []): void
    {
        $writableDirectories = [...$this->defaultWritableDirectories, ...$directories];

        set('writable_dirs', $writableDirectories);
    }

    public function setRsyncDirectories(string $src, string $dest): void
    {
        set('rsync_src', $src);
        set('rsync_dest', $dest);
    }
}
