<?php

namespace Concept7\Deployer\Recipe\Laravel\Multitenancy;

use Concept7\Deployer\Recipe\Base;
use Concept7\Deployer\Traits\HorizonTerminate;
use Concept7\Deployer\Traits\MultitenancyArtisan;
use Concept7\Deployer\Traits\RestartSupervisordDaemon;
use Concept7\Deployer\Traits\UploadAssets;
use Concept7\Deployer\Traits\UploadVendors;

class Laravel extends Base
{
    use HorizonTerminate;
    use MultitenancyArtisan;
    use RestartSupervisordDaemon;
    use UploadAssets;
    use UploadVendors;

    /** @var array<string> */
    protected array $deploySteps = [
        'deploy:prepare',
        'upload:vendors',
        'upload:assets',
        'artisan:storage:link',
        'artisan:migrate',
        'deploy:publish',
        'php-fpm-reload',
        'cachetool:clear:opcache',
        'artisan:config:cache',
        'artisan:event:cache',
        'artisan:route:cache',
        'artisan:view:cache',
        'forge:artisan:horizon:terminate',
        'supervisord-daemon-restart',
    ];

    /** @var array<string> */
    protected array $additionalDeployerRecipes = [
        'recipe/laravel.php',
    ];

    public function loadExtraDeployerSteps(): void
    {
        $this->uploadVendors();
        $this->uploadAssets();
        $this->forgeHorizonTerminate();
        $this->registerArtisanTasks();
        $this->setupSupervisord();
    }
}
