<?php

namespace Concept7\Deployer\Recipe\Laravel;

use Concept7\Deployer\Recipe\Base;
use Concept7\Deployer\Traits\CheckGitStatus;
use Concept7\Deployer\Traits\HorizonRestart;
use Concept7\Deployer\Traits\RestartSupervisordDaemon;
use Concept7\Deployer\Traits\SetCodeStrategy;
use Concept7\Deployer\Traits\UploadAssets;
use Concept7\Deployer\Traits\UploadVendors;
use Concept7\Deployer\Traits\WebsocketsRestart;

class LaravelStatamic extends Base
{
    use CheckGitStatus;
    use HorizonRestart;
    use RestartSupervisordDaemon;
    use SetCodeStrategy;
    use UploadAssets;
    use UploadVendors;
    use WebsocketsRestart;

    /** @var array<string> */
    protected array $deploySteps = [
        'deploy:prepare',
        'upload:vendors',
        'upload:assets',
        'artisan:storage:link',
        'artisan:migrate',
        'deploy:publish',
        'php:restart',
        'cachetool:clear:opcache',
        'artisan:optimize:clear',
        'artisan:optimize',
        'artisan:view:cache',
        'artisan:event:cache',
        'statamic:stache:refresh',
        'horizon:restart',
        'websockets:restart',
    ];

    /** @var array<string> */
    protected array $additionalDeployerRecipes = [
        'recipe/laravel.php',
        'recipe/statamic.php',
    ];

    public function loadExtraDeployerSteps(): void
    {
        $this->uploadVendors();
        $this->uploadAssets();
        $this->horizonRestart();
        $this->websocketsRestart();
        $this->checkGitStatus();
        $this->setCodeStrategy();
        $this->setupSupervisord();
    }
}
