<?php

namespace Concept7\DeployerExtended\Recipe\Laravel;

use Concept7\DeployerExtended\Recipe\Base;
use Deployer\Exception\GracefulShutdownException;

use function Deployer\after;
use function Deployer\run;
use function Deployer\set;
use function Deployer\task;
use function Deployer\upload;

class Statamic extends Base
{
    protected $deploySteps = [
        'deploy:prepare',
        'upload:vendors',
        'rsync',
        'artisan:storage:link',
        'artisan:optimize:clear',
        'statamic:stache:warm',
        'deploy:publish',
        'php-fpm-reload',
        'forge:artisan:horizon:terminate',
        'supervisord-daemon-restart',
    ];

    public function __construct()
    {
        parent::__construct();
        require_once 'recipe/statamic.php';
    }

    public function run()
    {
        parent::run();
        $this->uploadVendors();
        $this->copyAssets();
        $this->forgeHorizonTerminate();
        $this->checkGitStatus();
        $this->updateCodeStrategy();
    }

    private function uploadVendors()
    {
        task('upload:vendors', function () {
            upload('vendor/', '{{release_path}}/vendor', ['flags' => '-az', 'progress_bar' => false, 'display_stats' => false]);
            upload('public/vendor/', '{{release_path}}/public/vendor', ['flags' => '-az', 'progress_bar' => false, 'display_stats' => false]);
        });
    }

    private function copyAssets()
    {
        task('copy:assets', function () {
            upload('public/build/', '{{release_path}}/public/build', ['flags' => '-az', 'progress_bar' => false, 'display_stats' => false]);
            // upload('public/css/', '{{release_path}}/public/css', ['flags' => '-az', 'progress_bar' => false, 'display_stats' => false]);
            // upload('public/js/', '{{release_path}}/public/js', ['flags' => '-az', 'progress_bar' => false, 'display_stats' => false]);
        });
    }

    public function forgeHorizonTerminate()
    {
        task('forge:artisan:horizon:terminate', ['artisan:horizon:terminate'])
            ->select('stage=staging,stage=testing,stage=acceptance');
    }

    public function checkGitStatus()
    {
        task('check:git-status', function () {
            $locked = run('cd {{current_path}}; if [[ $(git cherry -v) ]]; then echo +locked; else echo "-locked"; fi');
            if ($locked === '+locked') {
                throw new GracefulShutdownException("There are still some Git commits which haven't been pushed!");
            }
        });
        after('deploy:setup', 'check:git-status');
    }

    public function updateCodeStrategy()
    {
        set('update_code_strategy', 'clone');
    }
}
