<?php

namespace Concept7\DeployerExtended\Recipe\Laravel\Multitenancy;

use Concept7\DeployerExtended\Recipe\Base;

use function Deployer\artisan;
use function Deployer\task;
use function Deployer\upload;

class LaravelStatamic extends Base
{
    protected $deploySteps = [
        'deploy:prepare',
        'upload:vendors',
        'copy:assets',
        'artisan:storage:link',
        // 'artisan:config:cache',
        'tenant:artisan:route:cache',
        // 'artisan:view:cache',
        // 'artisan:event:cache',
        'landlord:artisan:migrate',
        'tenant:artisan:migrate',
        'deploy:publish',
    ];

    public function __construct()
    {
        parent::__construct();
        require_once 'recipe/laravel.php';
        require_once 'recipe/statamic.php';
    }

    public function run()
    {
        parent::run();
        $this->uploadVendors();
        $this->copyAssets();
        $this->forgeHorizonTerminate();
        $this->registerArtisanTasks();
    }

    private function uploadVendors()
    {
        task('upload:vendors', function () {
            upload('vendor/', '{{release_path}}/vendor', ['flags' => '-az', 'progress_bar' => false, 'display_stats' => false]);
            upload('public/vendor/', '{{release_path}}/public/vendor', ['flags' => '-az', 'progress_bar' => false, 'display_stats' => false]);
        });
    }

    private function copyAssets()
    {
        task('copy:assets', function () {
            upload('public/build/', '{{release_path}}/public/build', ['flags' => '-az', 'progress_bar' => false, 'display_stats' => false]);
            upload('public/css/', '{{release_path}}/public/css', ['flags' => '-az', 'progress_bar' => false, 'display_stats' => false]);
            upload('public/js/', '{{release_path}}/public/js', ['flags' => '-az', 'progress_bar' => false, 'display_stats' => false]);
        });
    }

    private function forgeHorizonTerminate()
    {
        task('forge:artisan:horizon:terminate', ['artisan:horizon:terminate'])
            ->select('stage=staging,stage=testing,stage=acceptance');
    }

    private function registerArtisanTasks()
    {
        task('landlord:artisan:migrate', artisan('migrate --path=database/migrations/landlord --database=landlord'));
        task('tenant:artisan:migrate', artisan('tenants:artisan "migrate --path=database/migrations/tenant --database=tenant"'));
        task('tenant:artisan:route:cache', artisan('tenants:artisan route:cache'));
    }
}
