<?php

namespace Concept7\DeployerExtended\Recipe\Laravel;

use Concept7\DeployerExtended\Recipe\Base;

use function Deployer\task;
use function Deployer\upload;

class LaravelStatamic extends Base
{
    protected $deploySteps = [
        'deploy:prepare',
        'upload:vendors',
        'copy:assets',
        'artisan:storage:link',
        'artisan:migrate',
        'deploy:publish',
        'php-fpm-reload',
        'cachetool:clear:opcache',
        'artisan:config:cache',
        'artisan:route:cache',
        'artisan:view:cache',
        'artisan:event:cache',
        'forge:artisan:horizon:terminate',
        'supervisord-daemon-restart',
    ];

    public function __construct()
    {
        parent::__construct();
        require_once 'recipe/laravel.php';
        require_once 'recipe/statamic.php';
    }

    public function run()
    {
        parent::run();
        $this->uploadVendors();
        $this->copyAssets();
        $this->forgeHorizonTerminate();
    }

    private function uploadVendors()
    {
        task('upload:vendors', function () {
            upload('vendor/', '{{release_path}}/vendor', ['flags' => '-az', 'progress_bar' => false, 'display_stats' => false]);
            upload('public/vendor/', '{{release_path}}/public/vendor', ['flags' => '-az', 'progress_bar' => false, 'display_stats' => false]);
        });
    }

    private function copyAssets()
    {
        task('copy:assets', function () {
            upload('public/build/', '{{release_path}}/public/build', ['flags' => '-az', 'progress_bar' => false, 'display_stats' => false]);
            // upload('public/css/', '{{release_path}}/public/css', ['flags' => '-az', 'progress_bar' => false, 'display_stats' => false]);
            // upload('public/js/', '{{release_path}}/public/js', ['flags' => '-az', 'progress_bar' => false, 'display_stats' => false]);
        });
    }

    private function forgeHorizonTerminate()
    {
        task('forge:artisan:horizon:terminate', ['artisan:horizon:terminate'])
            ->select('stage=staging,stage=testing,stage=acceptance');
    }
}
