```php
require __DIR__.'/vendor/autoload.php';

use Concept7\DeployerExtended\Enum\Recipe;
use Concept7\DeployerExtended\Loader;

$loader = new Loader();

$loader
    ->setProject(
        name: 'POH Digitaal',
        repository: 'git@gitlab.concept7.nl:poh-digitaal/poh-digitaal.git'
    )
    ->setRecipe(Recipe::Laravel)
    ->setPhpVersion(8.1)
    ->setStaging(
        host: 'poh-digitaal.staging.concept7.dev',
        deploy_path: '~/poh-digitaal.staging.concept7.dev',
    )
    ->setAcceptance(
        host: 'poh-digitaal.acceptance.concept7.dev',
        deploy_path: '~/poh-digitaal.acceptance.concept7.dev',
    )
    ->setProduction(
        host: 'beheer.pohdigitaal.nl',
        hostname: 'd-concept7-6.host-ed.eu',
        port: 22622,
        remote_user: 'u_pohdigitaal',
        deploy_path: '/var/hpwsites/u_pohdigitaal/website/html/webroot',
    )
    ->execute();
```



```
composer config repositories.253 composer https://gitlab.concept7.nl/api/v4/group/253/-/packages/composer/packages.json
composer require concept7/deployer

```